﻿//***************************************************
// 13a_I2C_AddressScan
#include "mbed.h"

I2C i2c(I2C_SDA, I2C_SCL);    // PB_9, PB_8

int main()
{
    for (int addr=0; addr<128; addr++) {
// Achtung: mbed will nach der 7 Bit-I2C-Addresse gleich noch das R/!W Bit
        int ack = i2c.write(addr<<1, NULL, 0, false);
        if (ack == 0) {
            printf("I2C device detected at address = %2Xh\n", addr);
        }
    }
    while (1) {}
}

//***************************************************
// 13b_I2C_AddresScan
#include "mbed.h"

I2C i2c(I2C_SDA, I2C_SCL);    // PB_9, PB_8

int main()
{
    for (int addr=0; addr<128; addr++) {
        i2c.start();
        // Achtung: mbed will nach der 7 Bit-I2C-Addresse gleich noch das R/!W Bit
        int success = i2c.write(addr<<1);
        i2c.stop();
        if(success==1) {
            printf("I2C device detected at address = %2Xh \n", addr);
        }
    }
    while(1) {}
}
//***************************************************
// 13c_I2C_EEPROM_24C02
#include "mbed.h"
#define ADDR_24C02  0x50   // 0x50<<1 --> 0xA0  EEPROM

I2C i2c(I2C_SDA, I2C_SCL); // PB_9, PB_8

int main()
{
    char data_write[5];
    data_write[0] = 0x10; // interne EEPROM Adresse
    data_write[1] = 0x33; // 0x33 an interne Adresse 0x10
    data_write[2] = 0x44; // 0x44 an interne Adresse 0x11
    data_write[3] = 0x55; // 0x44 an interne Adresse 0x12
    data_write[4] = 0x66; // 0x44 an interne Adresse 0x13

    i2c.write(ADDR_24C02<<1, data_write, 5, false);

    ThisThread::sleep_for(500ms);

    char data_read[4];
    i2c.write(ADDR_24C02<<1, data_write, 1, true); // repeated
    i2c.read(ADDR_24C02<<1, data_read, 4, false);
    printf("%2X %2X %2X %2X \n",data_read[0],data_read[1],data_read[2],data_read[3]); 
    
    while (1) { }
}
//***************************************************
// 13d_I2C_ADC_MCP3221 
// 12-Bit ADC Messung
#include "mbed.h"
I2C i2c(I2C_SDA, I2C_SCL); // PB_9, PB_8
#define ADDR_MCP3221 0x4D  // 0x4D<<1 --> 0x9A  ADC
int main() {
  char data_read[2];
  while (1) {

    i2c.read(ADDR_MCP3221<<1, data_read, 2);
    printf("%X %02X ", data_read[0], data_read[1]);
    // float spannung = 3.3*((data_read[0] << 8) | data_read[1]) / 4095.0;
    // printf("%.2f V\n", spannung);
    int  spg100 = (int) (330 * ((data_read[0] << 8) | data_read[1]) / 4095);
    char vk  = '0' + spg100/100;
    char nk1 = '0' + spg100/10%10;
    char nk2 = '0' + spg100%10;
    printf("-> %c.%c%c V\n", vk,nk1,nk2);
    ThisThread::sleep_for(1s);
  }
}
// ******************************************
// 13e_I2C_DAC_TC1321_Saegezahn
#include "mbed.h"
#define ADDR_TC1321 0x48 // 0x48<<1 --> 0x90  DAC

I2C i2c(I2C_SDA, I2C_SCL); // PB_9, PB_8
void initI2C() {
  char data_write[] = {0x01, 0x00}; // Config to Normal
  i2c.write(ADDR_TC1321<<1, data_write, 2);
}

int main() {
  initI2C();  // zur Sicherheit
  char data_write[] = {0x00,0x00,0x00};
  while (1) {
    for (char value = 0; value < 103; value++) {
      data_write[1] = value;
      i2c.write(ADDR_TC1321<<1, data_write, 3);
      ThisThread::sleep_for(97ms);
      wait_us(30);
    }
  }
}
// ******************************************
// 13f_I2C_DAC_TC1321_Sinus
// Achtung: I2C-Zugriff funktioniert nicht im Ticker bzw. Timeout
// Maybe this is been answered already, but the I2C component is not interrupt safe.
// The I2C component takes locks to make it thread-safe, which of course should not be used in an ISR.
// Note carefully the definitions of interrupt-safe and thread-safe in this document.
#include "mbed.h"
#define ADDR_TC1321 0x48    // 0x48<<1 --> 0x90  DAC
I2C i2c(I2C_SDA, I2C_SCL);  // PB_9, PB_8
// 24 Werte
int sinusTabelle[] = {0x1FF, 0x283, 0x2FF, 0x369, 0x3BA, 0x3ED, 0x3FF, 0x3ED,
                      0x3BA, 0x369, 0x2FF, 0x283, 0x1FF, 0x17B, 0x0FF, 0x095,
                      0x044, 0x011, 0x000, 0x011, 0x044, 0x095, 0x0FF, 0x17B};

Ticker ticker;
void initI2C() {
  char data_write[] = {0x01, 0x00};    // Config to Normal
  i2c.write(ADDR_TC1321<<1, data_write, 2);
}

bool newValue = false;
void isrTicker() { newValue = true; }

int main() {
  printf("go");
  initI2C();
  int i = 0;
  char data_write[] = {0x00, 0x7F,0xC0};   // Data Register
  //  bei 50Hz und 24 Werten in der Tabelle
  //  t = 1 / (50*24) = 833us
  ticker.attach(&isrTicker, 833us); 
  while (1) {
    if (newValue) {
      i2c.write(ADDR_TC1321, data_write, 3);
      i++;
      i %= 24;
      data_write[1] = (char) (sinusTabelle[i]>>2);
      data_write[2] = (char) ((sinusTabelle[i]&0x03)<<6);
      newValue = false;
    }
  }
}
// ******************************************
// 13g_I2C_IO-Expander_MCP23008_Lauflicht
#include "mbed.h"
#define ADDR_MCP23008 0x20   // 0x20<<1 --> 0x40 IO-Expander
I2C i2c(I2C_SDA, I2C_SCL);   // PB_9, PB_8
Ticker ticker;

void initI2C() {
  char data_write[] = {0x00, 0x00}; // IODIR all outputs
  i2c.write(ADDR_MCP23008<<1, data_write, 2, false);
}

bool newValue = false;

void isrTicker() { newValue = true; }

int main() {
  initI2C();
  int i = 0;
  char data_write[] = {0x09, 0x00}; // GPIO Register

  ticker.attach(&isrTicker, 500ms);
  while (1) {
    if (newValue) {
      data_write[1] = 0x01 << i;
      i2c.write(ADDR_MCP23008<<1, data_write, 2, false);
      i++;
      i %= 8;
      newValue = false;
    }
  }
}
// ******************************************
// 13h_I2C_IO-Expander_MCP23008_Read
#include "mbed.h"
#define ADDR_MCP23008 0x20   // 0x20<<1 --> 0x40 IO-Expander
I2C i2c(I2C_SDA, I2C_SCL);   // PB_9, PB_8
PortOut pc70(PortC,0x00FF);


void initI2C() {
  char data_IODIR[] = {0x00, 0xFF}; // all inputs
  i2c.write(ADDR_MCP23008<<1, data_IODIR, 2);
  char data_IPOL[] = {0x01,0xFF};  // Invert all
  i2c.write(ADDR_MCP23008<<1, data_IPOL, 2);
  char data_GPPU[] = {0x06,0xFF};  // PullUp all
  i2c.write(ADDR_MCP23008<<1, data_GPPU, 2);
}

int main() {
  initI2C();
  char data_write[] = {0x09}; // Address  of GPIO Register
  char data_read[1];

  while (1) {
      i2c.write(ADDR_MCP23008<<1, data_write, 1, true);
      i2c.read(ADDR_MCP23008<<1, data_read, 1, false);
      pc70=data_read[0];
      printf("%X \n",data_read[0]);
      ThisThread::sleep_for(1s);
  }
}
// ******************************************
// 13i_I2C_IO-Expander_MCP23008_Interrupt
#include "mbed.h"
#define ADDR_MCP23008 0x20 // 0x20<<1 --> 0x40 IO-Expander
I2C i2c(I2C_SDA, I2C_SCL); // PB_9, PB_8
InterruptIn interruptPin(PC_8);

void initI2C() {
  char data_IOCON[] = {0x05, 0b00100010};
  i2c.write(ADDR_MCP23008 << 1, data_IOCON, 2);
  char data_IODIR[] = {0x00, 0xFF}; // all inputs
  i2c.write(ADDR_MCP23008 << 1, data_IODIR, 2);
  char data_GPPU[] = {0x06, 0xFF}; // PullUp all
  i2c.write(ADDR_MCP23008 << 1, data_GPPU, 2);
  char data_IPOL[] = {0x01, 0x00}; // don't Invert all
  i2c.write(ADDR_MCP23008 << 1, data_IPOL, 2);
  char data_DEFVAL[] = {0x03, 0x0F}; // Default Values
  i2c.write(ADDR_MCP23008 << 1, data_DEFVAL, 2);
  char data_GPINT[] = {0x03, 0xFF}; // Interrupt on Change
  i2c.write(ADDR_MCP23008 << 1, data_GPINT, 2);
  char data_INTCON[] = {0x04, 0xFF}; // Interrupt control
  i2c.write(ADDR_MCP23008 << 1, data_INTCON, 2);
}
bool newValue = false;
void isrExt() { newValue = true; }

int main() {
  initI2C();
  interruptPin.rise(&isrExt);

  char data_write[] = {0x08}; // Address  of INTCAP
  char data_read[1];

  while (1) {
    if (newValue) {
      i2c.write(ADDR_MCP23008 << 1, data_write, 1);
      i2c.read(ADDR_MCP23008 << 1, data_read, 1);
      printf("%X \n", data_read[0]);
      newValue = false;
    }
    ThisThread::sleep_for(100ms);
  }
}
//***************************************************
// 13j_I2C_Temperatur_Sensor_MCP9801
#include "mbed.h"
#define ADDR_MCP9801 0x49  // 0x49<<1 --> 0x92  Temperatur Sensor
I2C i2c(I2C_SDA, I2C_SCL); // PB_9, PB_8

void init_MCP9801() {
  // One-shot disabled
  // 12 Bit resolution
  // default fault queue
  // alert active-high (open drain output)
  // comparator mode
  // shutdown disabled
  char data_CONFIG[] = {0x01, 0b01100100}; // Configuration reegister
  i2c.write(ADDR_MCP9801<<1, data_CONFIG, 2);
  // 26.0 -> Temperatur Hysteresis reegister (THyst)
  char data_THYST[] = {0x02, 0b00011010, 0b00000000};
  i2c.write(ADDR_MCP9801<<1, data_THYST, 3);
  // 28.0  -> Temperatur Limit-set register (TSet)
  char data_TSET[] = {0x03, 0b00011100, 0b0000000};
  i2c.write(ADDR_MCP9801<<1, data_TSET, 3);
  // Temperatur register (TA)
  char data_write[] = {0x00};
  i2c.write(ADDR_MCP9801<<1, data_write, 1);
}

int main() {
  init_MCP9801();
  char data_read[2];
  while (1) {
    i2c.read(ADDR_MCP9801<<1, data_read, 2);
    printf("%02X %02X\n", data_read[0], data_read[1]);
    if ((data_read[0] & 0x80) == 0x00) { // Temperatur positiv
      float temperatur = data_read[0] + data_read[1] / 256.0;
      int temp100 = (int)(100.0 * temperatur);
      char vk2 = '0' + temp100 / 1000 % 10;
      char vk1 = '0' + temp100 / 100 % 10;
      char nk1 = '0' + temp100 / 10 % 10;
      char nk2 = '0' + temp100 % 10;
      printf("-> %c%c.%c%c C°\n", vk2, vk1, nk1, nk2);
    }
    ThisThread::sleep_for(1s);
  }
}









